/**
 * @license
 * Copyright 2021 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * Number of characters to truncate a collapsed block to.
 *
 * @internal
 */
export declare const COLLAPSE_CHARS = 30;
/**
 * When dragging a block out of a stack, split the stack in two (true), or drag
 * out the block healing the stack (false).
 *
 * @internal
 */
export declare const DRAG_STACK = true;
/**
 * Lookup table for determining the opposite type of a connection.
 *
 * @internal
 */
export declare const OPPOSITE_TYPE: number[];
/**
 * String for use in the dropdown created in field_variable.
 * This string indicates that this option in the dropdown is 'Rename
 * variable...' and if selected, should trigger the prompt to rename a variable.
 *
 * @internal
 */
export declare const RENAME_VARIABLE_ID = "RENAME_VARIABLE_ID";
/**
 * String for use in the dropdown created in field_variable.
 * This string indicates that this option in the dropdown is 'Delete the "%1"
 * variable' and if selected, should trigger the prompt to delete a variable.
 *
 * @internal
 */
export declare const DELETE_VARIABLE_ID = "DELETE_VARIABLE_ID";
//# sourceMappingURL=internal_constants.d.ts.map